<section class="services-details-wrapper section-padding">
    <div class="container">
        <div class="col-lg-10 col-12 offset-lg-1">
            <div class="services-contents">

                @if(Auth::user())
                    @can('service check')
                        <div class="easier-mode">
                            @if(Auth::user())
                                @can('service check')
                                    <!-- hover effect for mobile devices  -->
                                    <div class="click-icon d-md-none text-center">
                                        <button class="custom-btn text-white">
                                            <i class="fa fa-mobile-alt text-white"></i> {{ __('content.touch') }}
                                        </button>
                                    </div>
                                @endcan
                            @endif
                            <div class="easier-section-area">
                                @endcan
                                @endif

                                @isset ($service_content)
                                    @if (!empty($service_content->section_image))
                                        <img  src="{{ asset('uploads/img/service/'.$service_content->section_image) }}" alt="service image">
                                    @endif
                                    <p class="mt-4">@php echo html_entity_decode($service_content->description); @endphp</p>
                                @else
                                    @if (Auth::user() || $draft_view == null || $draft_view->status == 'enable')
                                        <img src="{{ asset('uploads/img/dummy/1080x540.webp') }}" alt="service image">

                                        <p class="mt-4"><b>An automated report is a management tool used by professionals to create and share business reports at a specific time  information each time. These updates are usually made in real-time with the help of automated reporting tools.</b></p>

                                        <p class="mt-4">Data, information, and insights are all around us. Before we even realize our business potentials and  in our competitive market, there is always a new business plan to make, a new strategy to develop, a new report to generate - and they all take time. Since amounts of data are generated by every second, businesses are always on the lookout for the best possible online data analysis tools  make their processes easier, faster, and more effective.</p>
                                        <p class="mt-4">Productivity has become the epitome of successful business processes. While every manager seeks how to increase productivity and decrease business costs, some invaluable processes can push towards sustainable business development - automated reportin and systems are the answer you've been looking for.</p>
                                        <p class="mt-4">That said, in this post, we will explain what is an automated report and its benefits, the ins and outs of the automat process, and finish with examples from the real business world. After reading this article, you will be equipped to create your own automation practic and upscale your reports with the help of a modern online reporting software.</p>

                                        <p class="mt-4"><b>The process of making our automated reporting work</b></p>
                                        <p class="mt-4">The manufacturing industry needs continuous automation throughout processes, and each part of the company needs to work flawlessly in order to avoid potential business issues and cost increment.</p>
                                    @endif
                                @endisset

                                @if(Auth::user())
                                    @can('service check')
                            </div>
                            <div class="easier-middle">
                                @php
                                    $url = request()->path();
                                    $modified_url = str_replace('/', '-bracket-', $url);
                                @endphp
                                <form method="POST" action="{{ route('site-url.index') }}" class="d-inline-block">
                                    @csrf
                                    <input type="hidden" name="route" value="service-content.create">
                                    <input type="hidden" name="style" value="{{ $service->id }}">
                                    <input type="hidden" name="site_url" value="{{ $modified_url }}">
                                    <button type="submit" class="custom-btn text-white me-2">
                                        <i class="fa fa-edit text-white"></i> {{ __('content.edit_service_content') }}
                                    </button>
                                </form>

                            </div>
                        </div>
                    @endcan
                @endif

                    @if(Auth::user())
                        @can('service check')
                            <div class="easier-mode">
                                @if(Auth::user())
                                    @can('service check')
                                        <!-- hover effect for mobile devices  -->
                                        <div class="click-icon d-md-none text-center">
                                            <button class="custom-btn text-white">
                                                <i class="fa fa-mobile-alt text-white"></i> {{ __('content.touch') }}
                                            </button>
                                        </div>
                                    @endcan
                                @endif
                                <div class="easier-section-area">
                                    @endcan
                                    @endif

                                    @if (is_countable($service_processes) && count($service_processes) > 0)

                                        @php $i = 1; @endphp
                                        @foreach($service_processes->chunk(3) as $service_process)

                                            <div class="work-process-wrapper row fw500">

                                                @foreach ($service_process as $item)
                                                    <div class="col-xl-4 col-md-6 text-center @if (!$loop->first) mt-xl-5 @endif">
                                                        @if(Auth::user())
                                                            @can('service check')
                                                                <form method="POST" action="{{ route('site-url.index') }}" class="d-inline-block">
                                                                    @csrf
                                                                    <input type="hidden" name="route" value="service-process.edit">
                                                                    <input type="hidden" name="style" value="">
                                                                    <input type="hidden" name="service_id" value="{{ $service->id }}">
                                                                    <input type="hidden" name="id" value="{{ $item->id }}">
                                                                    <input type="hidden" name="site_url" value="{{ $modified_url }}">
                                                                    <button type="submit" class="me-2 custom-pure-button">
                                                                        <i class="fa fa-edit text-info easier-custom-font-size-24"></i>
                                                                    </button>
                                                                </form>
                                                            @endcan
                                                        @endif
                                                        <div class="single-work-process">
                                                            <div class="icon">
                                                                {{ $i++ }}
                                                            </div>
                                                            <div class="content">
                                                                <h5>@php echo html_entity_decode($item->title); @endphp</h5>
                                                                <p>@php echo html_entity_decode($item->description); @endphp</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                                @unset ($item)

                                                <div class="wave-line d-none d-xl-block">
                                                    <img src="{{ asset('uploads/img/dummy/icons/wave.png') }}" alt="wave image">
                                                </div>
                                            </div>

                                        @endforeach
                                        @unset ($service_process)

                                    @else
                                        @if (Auth::user() || $draft_view == null || $draft_view->status == 'enable')
                                            <div class="work-process-wrapper row fw500">
                                                <div class="col-xl-4 col-md-6 text-center">
                                                    <div class="single-work-process">
                                                        <div class="icon">
                                                            1
                                                        </div>
                                                        <div class="content">
                                                            <h5>Set a data loader</h5>
                                                            <p>The manufacturing industry needs continuous automation throughout processes</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xl-4 col-md-6 text-center mt-xl-5">
                                                    <div class="single-work-process">
                                                        <div class="icon">
                                                            2
                                                        </div>
                                                        <div class="content">
                                                            <h5>Reporting workflow</h5>
                                                            <p>Marketing is one of the functions that need regular & updated reports analysis and workflow</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xl-4 col-md-6 text-center mt-xl-5">
                                                    <div class="single-work-process">
                                                        <div class="icon">
                                                            3
                                                        </div>
                                                        <div class="content">
                                                            <h5>Update information</h5>
                                                            <p>By sending this report weekly or monthly, without the need to update information manually update </p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="wave-line d-none d-xl-block">
                                                    <img src="{{ asset('uploads/img/dummy/icons/wave.png') }}" alt="wave image">
                                                </div>
                                            </div>
                                        @endif
                                    @endif

                                    @if(Auth::user())
                                        @can('service check')
                                </div>
                                <div class="easier-middle">
                                    @php
                                        $url = request()->path();
                                        $modified_url = str_replace('/', '-bracket-', $url);
                                    @endphp
                                    <form method="POST" action="{{ route('site-url.index') }}" class="d-inline-block">
                                        @csrf
                                        <input type="hidden" name="route" value="service-process.create">
                                        <input type="hidden" name="style" value="{{ $service->id }}">
                                        <input type="hidden" name="site_url" value="{{ $modified_url }}">
                                        <button type="submit" class="custom-btn text-white me-2 mb-2">
                                            <i class="fa fa-edit text-white"></i> {{ __('content.add_service_process') }}
                                        </button>
                                    </form>

                                </div>
                            </div>
                        @endcan
                    @endif

                    @if(Auth::user())
                        @can('service check')
                            <div class="easier-mode">
                                @if(Auth::user())
                                    @can('service check')
                                        <!-- hover effect for mobile devices  -->
                                        <div class="click-icon d-md-none text-center">
                                            <button class="custom-btn text-white">
                                                <i class="fa fa-mobile-alt text-white"></i> {{ __('content.touch') }}
                                            </button>
                                        </div>
                                    @endcan
                                @endif
                                <div class="easier-section-area">
                                    @endcan
                                    @endif

                                    @if (is_countable($service_items) && count($service_items) > 0)

                                        <ul>
                                            @foreach ($service_items as $service_item)
                                                @if(Auth::user())
                                                    @can('service check')
                                                        <form method="POST" action="{{ route('site-url.index') }}" class="d-inline-block">
                                                            @csrf
                                                            <input type="hidden" name="route" value="service-item.edit">
                                                            <input type="hidden" name="style" value="">
                                                            <input type="hidden" name="service_id" value="{{ $service->id }}">
                                                            <input type="hidden" name="id" value="{{ $service_item->id }}">
                                                            <input type="hidden" name="site_url" value="{{ $modified_url }}">
                                                            <button type="submit" class="me-2 custom-pure-button">
                                                                <i class="fa fa-edit text-info easier-custom-font-size-24"></i>
                                                            </button>
                                                        </form>
                                                    @endcan
                                                @endif
                                                <li>
                                                    <p>@php echo html_entity_decode($service_item->description); @endphp</p>
                                                </li>
                                            @endforeach
                                            @unset ($service_item)
                                        </ul>

                                    @else
                                        @if (Auth::user() || $draft_view == null || $draft_view->status == 'enable')
                                            <ul>
                                                <li>
                                                    <p><b>Time & cost savings:</b> If you automate reports, you will save colossal amounts of time and money on manually tracking, updating, and adding data to your reports. Naturally, time and money are correlated, so by automating reports, you will reap the rewards of valuable data-driven insights while empowering your team to place their efforts into more creative or strategic activities.</p>
                                                </li>
                                                <li>
                                                    <p><b>Accessibility, transparency & productivity:</b> By serving up automated insights from one central location, automatic reports will give everyone in the business the tools to perform better in their individual roles while benefiting from sharobust, reliable, and accurate.</p>
                                                </li>
                                                <li>
                                                    <p><b>Real-time decision-making:</b> When using manual reporting tools or processes, it’s easy to get bogged down. In addition to the more cumbersome reporting processes return data that is harder to understand and automated reports, you will gain access to accurate data presented in the form of visual.</p>
                                                </li>
                                            </ul>
                                        @endif
                                    @endif

                                    @if(Auth::user())
                                        @can('service check')
                                </div>
                                <div class="easier-middle">
                                    @php
                                        $url = request()->path();
                                        $modified_url = str_replace('/', '-bracket-', $url);
                                    @endphp
                                    <form method="POST" action="{{ route('site-url.index') }}" class="d-inline-block">
                                        @csrf
                                        <input type="hidden" name="route" value="service-item.create">
                                        <input type="hidden" name="style" value="{{ $service->id }}">
                                        <input type="hidden" name="site_url" value="{{ $modified_url }}">
                                        <button type="submit" class="custom-btn text-white me-2 mb-2">
                                            <i class="fa fa-edit text-white"></i> {{ __('content.add_service_item') }}
                                        </button>
                                    </form>

                                </div>
                            </div>
                        @endcan
                    @endif

            </div>
        </div>
    </div>
</section>





