@extends('layouts.frontend.master')

@section('content')

    <!-- ============================ Page Title Start================================== -->
    <div class="page-title" style="background:#f4f4f4 @if (isset($breadcrumb))
            url({{ asset('uploads/img/general/'.$breadcrumb->breadcrumb_image) }});
    @else url({{ asset('uploads/img/dummy/1920x750.jpg') }});
    @endif" data-overlay="5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12">

                    <div class="breadcrumbs-wrap">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
                        </ol>
                        <h2 class="breadcrumb-title">Hello {{ Auth::user()->name }}, Welcome</h2>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- ============================ Page Title End ================================== -->

    <!-- ============================ User Dashboard ================================== -->
    <section class="gray pt-5 pb-5">
        <div class="container-fluid">

            <div class="row">

                <div class="col-lg-3 col-md-4">
                    <div class="property_dashboard_navbar">

                        <div class="dash_user_avater">
                            @if (!empty($user->profile_photo_path))
                                <img src="{{ asset('uploads/img/profile/'.$user->profile_photo_path) }}" class="img-fluid avater" alt="profile image">
                            @else
                                <img src="{{ asset('uploads/img/dummy/100x100.jpg') }}" class="img-fluid avater" alt="profile image">
                            @endif
                            <h4>{{ Auth::user()->name }}</h4>
                        </div>

                        <div class="dash_user_menues">
                            <ul>
                                <li class="active"><a href="dashboard.html"><i class="fa fa-tachometer-alt"></i>Dashboard<span class="notti_coun style-1">4</span></a></li>
                                <li><a href="{{ route('profile-page.edit') }}"><i class="fa fa-user-tie"></i>My Profile</a></li>
                                <li><a href="bookmark-list.html"><i class="fa fa-bookmark"></i>Saved Property<span class="notti_coun style-2">7</span></a></li>
                                <li><a href="my-property.html"><i class="fa fa-tasks"></i>My Properties</a></li>
                                <li><a href="messages.html"><i class="fa fa-envelope"></i>Messages<span class="notti_coun style-3">3</span></a></li>
                                <li><a href="choose-package.html"><i class="fa fa-gift"></i>Choose Package<span class="expiration">10 days left</span></a></li>
                                <li><a href="submit-property-dashboard.html"><i class="fa fa-pen-nib"></i>Submit New Property</a></li>
                                <li><a href="change-password.html"><i class="fa fa-unlock-alt"></i>Change Password</a></li>
                            </ul>
                        </div>

                        <div class="dash_user_footer">
                            <ul>
                                <li>
                                    <a href="{{ route('logout') }}"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        <i class="fa fa-power-off"></i>
                                    </a>
                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                        @csrf
                                    </form>
                                </li>
                                <li><a href="#"><i class="fa fa-comment"></i></a></li>
                                <li><a href="#"><i class="fa fa-cog"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-lg-9 col-md-8">
                    <div class="dashboard-body">

                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12">
                                <h4>Your Current Package: <span class="pc-title theme-cl">Gold Package</span></h4>
                            </div>
                        </div>

                        <div class="row">

                            <div class="col-lg-4 col-md-6 col-sm-12">
                                <div class="dashboard_stats_wrap widget-1">
                                    <div class="dashboard_stats_wrap_content"><h4>607</h4> <span>Listed Property</span></div>
                                    <div class="dashboard_stats_wrap-icon"><i class="ti-location-pin"></i></div>
                                </div>
                            </div>

                            <div class="col-lg-4 col-md-6 col-sm-12">
                                <div class="dashboard_stats_wrap widget-3">
                                    <div class="dashboard_stats_wrap_content"><h4>$10,540</h4> <span>Earned This Week</span></div>
                                    <div class="dashboard_stats_wrap-icon"><i class="ti-wallet"></i></div>
                                </div>
                            </div>

                            <div class="col-lg-4 col-md-6 col-sm-12">
                                <div class="dashboard_stats_wrap widget-2">
                                    <div class="dashboard_stats_wrap_content"><h4>5,40580</h4> <span>Earned This Month</span></div>
                                    <div class="dashboard_stats_wrap-icon"><i class="ti-credit-card"></i></div>
                                </div>
                            </div>

                        </div>
                        <!--  row -->

                        <div class="row">
                            <div class="col-lg-8 col-md-7 col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="mb-0">Extra Area Chart</h4>
                                    </div>
                                    <div class="card-body">
                                        <ul class="list-inline text-center m-t-40">
                                            <li>
                                                <h5><i class="fa fa-circle m-r-5 text-warning"></i>Website A</h5>
                                            </li>
                                            <li>
                                                <h5><i class="fa fa-circle m-r-5 text-danger"></i>Website B</h5>
                                            </li>
                                            <li>
                                                <h5><i class="fa fa-circle m-r-5 text-success"></i>Website C</h5>
                                            </li>
                                        </ul>
                                        <div class="chart" id="extra-area-chart" style="height: 300px;"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-4 col-md-5 col-sm-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h6>Notifications</h6>
                                    </div>
                                    <div class="ground-list ground-list-hove">
                                        <div class="ground ground-single-list">
                                            <a href="#">
                                                <div class="btn-circle-40 theme-cl theme-bg-light"><i class="ti-home"></i></div>
                                            </a>

                                            <div class="ground-content">
                                                <h6><a href="#">Your listing <strong>Azreal Modern</strong> has been approved!.</a></h6>
                                                <span class="small">Just Now</span>
                                            </div>
                                        </div>

                                        <div class="ground ground-single-list">
                                            <a href="#">
                                                <div class="btn-circle-40 theme-cl theme-bg-light"><i class="ti-comment-alt"></i></div>
                                            </a>

                                            <div class="ground-content">
                                                <h6><a href="#">Litha Lynes left a review on <strong>Renovated Apartment</strong></a></h6>
                                                <span class="small">20 min ago</span>
                                            </div>
                                        </div>

                                        <div class="ground ground-single-list">
                                            <a href="#">
                                                <div class="btn-circle-40 theme-cl theme-bg-light"><i class="ti-heart"></i></div>
                                            </a>

                                            <div class="ground-content">
                                                <h6><a href="#">Someone bookmark your View listing!<strong>Sargun Villa Bay</strong></a></h6>
                                                <span class="small">1 day ago</span>
                                            </div>
                                        </div>

                                        <div class="ground ground-single-list">
                                            <a href="#">
                                                <div class="btn-circle-40 theme-cl theme-bg-light"><i class="ti-home"></i></div>
                                            </a>

                                            <div class="ground-content">
                                                <h6><a href="#">Your listing <strong>Modern Family Home</strong> has been approved!.</a></h6>
                                                <span class="small">10 days ago</span>
                                            </div>
                                        </div>

                                        <div class="ground ground-single-list">
                                            <a href="#">
                                                <div class="btn-circle-40 theme-cl theme-bg-light"><i class="ti-comment-alt"></i></div>
                                            </a>

                                            <div class="ground-content">
                                                <h6><a href="#">Adam Brown left a review on <strong>Renovated Apartment</strong></a></h6>
                                                <span class="small">Just Now</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- row -->

                        <div class="row">
                            <div class="col-lg-12 col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="mb-0">Order Status</h4>
                                    </div>
                                    <div class="card-body p-0">
                                        <div class="table-responsive">
                                            <table class="table table-lg table-hover">
                                                <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Product ID</th>
                                                    <th>Status</th>
                                                    <th>Price</th>
                                                    <th>Date Created</th>
                                                </tr>
                                                </thead>

                                                <tbody>
                                                <tr>
                                                    <td><a href="#"><img src="assets/img/p-1.png" class="avatar avatar-30 mr-2" alt="Avatar">Luxury House</a></td>
                                                    <td>#258475</td>
                                                    <td><div class="label text-success bg-success-light">Paid</div></td>
                                                    <td>$ 310</td>
                                                    <td>04/10/2013</td>
                                                </tr>

                                                <tr>
                                                    <td><a href="#"><img src="assets/img/p-2.png" class="avatar avatar-30 mr-2" alt="Avatar">Sargun Apartment</a></td>
                                                    <td>#249578</td>
                                                    <td><div class="label text-warning bg-warning-light">Pending</div></td>
                                                    <td>$ 584.14</td>
                                                    <td>05/08/2014</td>
                                                </tr>

                                                <tr>
                                                    <td><a href="#"><img src="assets/img/p-3.png" class="avatar avatar-30 mr-2" alt="Avatar">Preet Silver City</a></td>
                                                    <td>#248712</td>
                                                    <td><div class="label text-danger bg-danger-light">Cancel</div></td>
                                                    <td>$ 710.5</td>
                                                    <td>11/05/2015</td>
                                                </tr>

                                                <tr>
                                                    <td><a href="#"><img src="assets/img/p-4.png" class="avatar avatar-30 mr-2" alt="Avatar">Mount See Villa</a></td>
                                                    <td>#287246</td>
                                                    <td><div class="label text-success bg-success-light">Paid</div></td>
                                                    <td>$ 482.70</td>
                                                    <td>06/09/2016</td>
                                                </tr>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- row -->

                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- ============================ User Dashboard End ================================== -->


@endsection
