<?php if(Auth::user()): ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog check')): ?>
        <div class="easier-mode">
            <div class="easier-section-area">
                <?php endif; ?>
                <?php endif; ?>

                <section class="news-wrapper section-padding fix">
                    <div class="container">
                        <?php if(Auth::user()): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog check')): ?>
                                <!-- hover effect for mobile devices  -->
                                <div class="click-icon d-md-none text-center">
                                    <button class="custom-btn text-white">
                                        <i class="fa fa-mobile-alt text-white"></i> <?php echo e(__('content.touch')); ?>

                                    </button>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-12">
                                <?php if(is_countable($blog_count_categories) && count($blog_count_categories) > 0): ?>
                                    <div class="text-center mb-5 custom-category-link">
                                        <a href="<?php echo e(url($page_builder->page_uri)); ?>" class="current mb-2"><?php echo e(__('frontend.all')); ?></a>
                                        <?php $__currentLoopData = $blog_count_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog_count_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(isset($blog_count_category->category->category_slug)): ?>
                                                <a class="link-secondary mb-2" href="<?php echo e(route('default-blog-category-index', $blog_count_category->category->category_slug)); ?>"><?php echo e($blog_count_category->category->category_name); ?> (<?php echo e($blog_count_category->category_count); ?>)</a>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php unset($blog_count_category); ?>
                                    </div>
                                <?php else: ?>
                                    <?php if(Auth::user() || $draft_view == null || $draft_view->status == 'enable'): ?>
                                        <div class="text-center mb-5 custom-category-link">
                                            <a href="#" class="link-dark">Creative</a>
                                            <a href="#" class="link-secondary">Business</a>
                                            <a href="#" class="link-secondary">UI / UX Design</a>
                                            <a href="#" class="link-secondary">Marketing</a>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                        <?php if(is_countable($blogs_paginate_style) && count($blogs_paginate_style) > 0): ?>
                            <div class="row">
                                <?php $__currentLoopData = $blogs_paginate_style; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6 col-xl-4 col-12">
                                        <?php if(Auth::user()): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog check')): ?>
                                                <?php
                                                    $url = request()->path();
                                                    $modified_url = str_replace('/', '-bracket-', $url);
                                                ?>
                                                <form method="POST" action="<?php echo e(route('site-url.index')); ?>" class="d-inline-block">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="route" value="blog.edit">
                                                    <input type="hidden" name="single_id" value="<?php echo e($item->id); ?>">
                                                    <input type="hidden" name="site_url" value="<?php echo e($modified_url); ?>">
                                                    <button type="submit" class="me-2 custom-pure-button">
                                                        <i class="fa fa-edit text-info easier-custom-font-size-24"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <div class="single-news-card wow fadeInUp">
                                            <div class="news-thumb bg-cover" style="<?php if(!empty($item->section_image)): ?> background-image: url('<?php echo e(asset('uploads/img/blog/thumbnail/'.$item->section_image)); ?>'); <?php endif; ?>"></div>
                                            <div class="contents">
                                                <div class="post-meta d-flex">
                                                    <div class="post-cat">
                                                        <a href="#"><?php echo e($item->category_name); ?></a>
                                                    </div>
                                                    <div class="post-date">
                                                        <span><?php echo e(Carbon\Carbon::parse($item->created_at)->format('d.m.Y')); ?></span>
                                                    </div>
                                                </div>
                                                <h4><a href="<?php echo e(route('default-blog-detail-show', ['slug' => $item->slug])); ?>"><?php echo e($item->title); ?></a></h4>
                                                <p><?php echo e($item->short_description); ?></p>
                                                <a href="<?php echo e(route('default-blog-detail-show', ['slug' => $item->slug])); ?>" class="read-more-link"><?php echo e(__('frontend.read_more')); ?> <i class="icon-arrow-right"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php unset($item); ?>
                            </div>
                            <div class="row mt-80">
                                <div class="col-xl-12 justify-content-center">
                                    <?php echo e($blogs_paginate_style->links()); ?>

                                </div>
                            </div>
                        <?php else: ?>
                            <?php if(Auth::user() || $draft_view == null || $draft_view->status == 'enable'): ?>
                                <div class="row">
                                    <div class="col-md-6 col-xl-4 col-12">
                                        <div class="single-news-card wow fadeInUp">
                                            <div class="news-thumb bg-cover" style="background-image: url('<?php echo e(asset('uploads/img/dummy/415x300.webp')); ?>');"></div>
                                            <div class="contents">
                                                <div class="post-meta d-flex">
                                                    <div class="post-cat">
                                                        <a href="#">Sponsored</a>
                                                    </div>
                                                    <div class="post-date">
                                                        <span>Dec. 8, 2023</span>
                                                    </div>
                                                </div>
                                                <h4><a href="#">What Is The Crypto Volatility Index (CVI)?</a></h4>
                                                <p>The Crypto Volatility Index (CVI) is a decentralized solution used as a benchmark to track...</p>
                                                <a href="#" class="read-more-link">read more <i class="icon-arrow-right"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-12">
                                        <div class="single-news-card wow fadeInUp" data-wow-delay=".2s">
                                            <div class="news-thumb bg-cover" style="background-image: url('<?php echo e(asset('uploads/img/dummy/415x300.webp')); ?>');"></div>
                                            <div class="contents">
                                                <div class="post-meta d-flex">
                                                    <div class="post-cat">
                                                        <a href="#">Business</a>
                                                    </div>
                                                    <div class="post-date">
                                                        <span>Nov. 4, 2023</span>
                                                    </div>
                                                </div>
                                                <h4><a href="#">How SocialGood Is Offering 100% Crypto</a></h4>
                                                <p>SocialGood takes on wealth inequality by allowing shoppers to earn crypto assets on their online...</p>
                                                <a href="#" class="read-more-link">read more <i class="icon-arrow-right"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-xl-4 col-12">
                                        <div class="single-news-card wow fadeInUp" data-wow-delay=".4s">
                                            <div class="news-thumb bg-cover" style="background-image: url('<?php echo e(asset('uploads/img/dummy/415x300.webp')); ?>');"></div>
                                            <div class="contents">
                                                <div class="post-meta d-flex">
                                                    <div class="post-cat">
                                                        <a href="#">Marketing</a>
                                                    </div>
                                                    <div class="post-date">
                                                        <span>Oct. 13, 2023</span>
                                                    </div>
                                                </div>
                                                <h4><a href="#">S&P Index Funds launched as Crypto</a></h4>
                                                <p>Digital assets company Securitize has unveiled two tokenized funds in partnership...</p>
                                                <a href="#" class="read-more-link">read more <i class="icon-arrow-right"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </section>

                <?php if(Auth::user()): ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog check')): ?>
            </div>
            <div class="easier-middle">
                <?php
                    $url = request()->path();
                    $modified_url = str_replace('/', '-bracket-', $url);
                ?>
                <form method="POST" action="<?php echo e(route('site-url.index')); ?>" class="d-inline-block">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="route" value="blog.index">
                    <input type="hidden" name="style" value="">
                    <input type="hidden" name="site_url" value="<?php echo e($modified_url); ?>">
                    <button type="submit" class="custom-btn text-white me-2 mb-2">
                        <i class="fa fa-edit text-white"></i> <?php echo e(__('content.edit_section_title_description')); ?>

                    </button>
                </form>
                <form method="POST" action="<?php echo e(route('site-url.index')); ?>" class="d-inline-block">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="route" value="blog.create">
                    <input type="hidden" name="style" value="">
                    <input type="hidden" name="site_url" value="<?php echo e($modified_url); ?>">
                    <button type="submit" class="custom-btn text-white">
                        <i class="fa fa-plus text-white"></i> <?php echo e(__('content.add_blog')); ?>

                    </button>
                </form>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/beevgisw/grievances/resources/views/frontend/sections/blog/blog-style2.blade.php ENDPATH**/ ?>