<?php $__env->startSection('content'); ?>

    <!-- Include Alert Blade -->
    <?php echo $__env->make('admin.alert.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="row">
        <div class="col-12 box-margin">
            <div class="card">
                <div class="card-body">
                    <div class="d-md-flex justify-content-between align-items-center mb-20">
                        <h6 class="card-title mb-0"><?php echo e(__('content.all_admin')); ?></h6>
                        <div>
                            <a href="<?php echo e(url('admin/admin-user/create')); ?>" class="btn btn-primary float-right mb-3">+ <?php echo e(__('content.add_admin_user')); ?></a>
                        </div>
                        </div>

                    <?php if(count($admin_users) > 0): ?>
                        <div>
                            <label for="created_by_super_admin">All Admin Created By Super Admin</label>
                        </div>

                        <table id="basic-datatable" class="table table-striped dt-responsive nowrap w-100">
                            <thead>
                            <tr>
                                <th><?php echo e(__('content.image')); ?></th>
                                <th><?php echo e(__('content.role_name')); ?></th>
                                <th><?php echo e(__('content.name')); ?></th>
                                <th><?php echo e(__('content.email')); ?></th>
                                <th class="custom-width-action"><?php echo e(__('content.action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $desc = count($admin_users); $asc=0; ?>
                            <?php $__currentLoopData = $admin_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($admin_user->getRoleNames()->first() != "super-admin"): ?>
                                    <tr>
                                        <td>

                                            <?php if(!empty($admin_user->profile_photo_path)): ?>
                                                <img class="image-size img-fluid" src="<?php echo e(asset('uploads/img/profile/admin/'.$admin_user->profile_photo_path)); ?>" alt="user image">
                                            <?php else: ?>
                                                <img class="image-size img-fluid" src="<?php echo e(asset('uploads/img/dummy/no-image.jpg')); ?>" alt="no image">
                                            <?php endif; ?>

                                        </td>
                                        <td><?php echo e($admin_user->getRoleNames()->first()); ?></td>
                                        <td><?php echo e($admin_user->name); ?></td>
                                        <td><?php echo e($admin_user->email); ?></td>
                                        <td>
                                            <div>
                                                <a href="<?php echo e(route('admin-user.edit', $admin_user->id)); ?>" class="mr-2">
                                                    <i class="fa fa-edit text-info font-18"></i>
                                                </a>
                                                <a href="#" data-toggle="modal" data-target="#deleteModel<?php echo e($admin_user->id); ?>">
                                                    <i class="fa fa-trash text-danger font-18"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>

                                    <!-- Modal -->
                                    <div class="modal fade" id="deleteModel<?php echo e($admin_user->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-sm" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalCenterTitle"><?php echo e(__('content.delete')); ?></h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('content.close')); ?>">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body text-center">
                                                    <?php echo e(__('content.you_wont_be_able_to_revert_this')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                <?php if($demo_mode == "on"): ?>
                                                    <!-- Include Alert Blade -->
                                                        <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    <?php else: ?>
                                                        <form class="d-inline-block" action="<?php echo e(route('admin-user.destroy', $admin_user->id)); ?>" method="POST">
                                                            <?php echo method_field('DELETE'); ?>
                                                            <?php echo csrf_field(); ?>
                                                            <?php endif; ?>

                                                        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('content.cancel')); ?></button>
                                                        <button type="submit" class="btn btn-success"><?php echo e(__('content.yes_delete_it')); ?></button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <span><?php echo e(__('content.not_yet_created')); ?></span>
                    <?php endif; ?>

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div><!-- end row-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/beevgisw/grievances/resources/views/admin/admin_user/index.blade.php ENDPATH**/ ?>