<?php $__env->startSection('content'); ?>

    <!-- Form row -->
    <div class="row">
        <div class="col-xl-12 box-margin height-card">
            <div class="card card-body">
                <h4 class="card-title"><?php echo e(__('content.tawk_to')); ?></h4>
                <?php if(isset($tawk_to)): ?>
                    <form action="<?php echo e(route('tawk-to.update', $tawk_to->id)); ?>" method="POST">
                        <?php echo method_field('PUT'); ?>
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="tawk_to"><?php echo e(__('content.tawk_to')); ?> </label>
                                    <textarea name="tawk_to" class="form-control" id="tawk_to" rows="10"><?php echo html_entity_decode($tawk_to->tawk_to); ?></textarea>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary mr-2"><?php echo e(__('content.submit')); ?></button>
                                <a href="#" class="btn btn-primary" data-toggle="modal" data-target="#tawkToDestroyModal<?php echo e($tawk_to->id); ?>">
                                    <i class="fa fa-trash"></i> <?php echo e(__('content.reset')); ?>

                                </a>
                            </div>
                        </div>
                    </form>

                    <!-- Modal -->
                    <div class="modal fade" id="tawkToDestroyModal<?php echo e($tawk_to->id); ?>" tabindex="-1" role="dialog" aria-labelledby="tawkToDestroyModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-sm" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="googleAnalyticDestroyModalCenterTitle"><?php echo e(__('content.delete')); ?></h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('content.close')); ?>">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body text-center">
                                    <?php echo e(__('content.you_wont_be_able_to_revert_this')); ?>

                                </div>
                                <div class="modal-footer">
                                    <?php if($demo_mode == "on"): ?>
                                        <!-- Include Alert Blade -->
                                        <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php else: ?>
                                        <form class="d-inline-block" action="<?php echo e(route('tawk-to.destroy', $tawk_to->id)); ?>" method="POST">
                                            <?php echo method_field('DELETE'); ?>
                                            <?php echo csrf_field(); ?>
                                            <?php endif; ?>

                                        <button type="button" class="btn btn-danger mr-1" data-dismiss="modal"><?php echo e(__('content.cancel')); ?></button>
                                        <button type="submit" class="btn btn-success"><?php echo e(__('content.yes_delete_it')); ?></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php else: ?>
                    <?php if($demo_mode == "on"): ?>
                        <!-- Include Alert Blade -->
                        <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <form action="<?php echo e(route('tawk-to.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php endif; ?>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="tawk_to"><?php echo e(__('content.tawk_to')); ?></label>
                                    <textarea name="tawk_to" class="form-control" id="tawk_to" rows="10"></textarea>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary mr-2"><?php echo e(__('content.submit')); ?></button>
                            </div>
                        </div>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/beevgisw/grievances/resources/views/admin/setting/tawk_to/create.blade.php ENDPATH**/ ?>