<?php $__env->startSection('content'); ?>

    <!-- Form row -->
    <div class="row">
        <div class="col-xl-12 box-margin height-card">
            <div class="card card-body">
                <h4 class="card-title"><?php echo e(__('content.site_info')); ?></h4>
            <?php if(isset($site_info)): ?>
                <?php if($demo_mode == "on"): ?>
                    <!-- Include Alert Blade -->
                        <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <form action="<?php echo e(route('site-info.update', $site_info->id)); ?>" method="POST">
                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>
                            <?php endif; ?>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="description"><?php echo e(__('content.description')); ?></label>
                                        <input type="text" name="description" class="form-control" id="description" value="<?php echo e($site_info->description); ?>">
                                        <small class="form-text text-muted"><?php echo e(__('content.recommended_tags')); ?>

                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('a', 'description')"><?php echo e(__('<a href="">')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('br', 'description')"><?php echo e(__('<br>')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('b', 'description')"><?php echo e(__('<b>')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('i', 'description')"><?php echo e(__('<i>')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('span', 'description')"><?php echo e(__('<span>')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('p', 'description')"><?php echo e(__('<p>')); ?></span>
                                        </small>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="copyright"><?php echo e(__('content.copyright')); ?></label>
                                        <input type="text" name="copyright" class="form-control" id="copyright" value="<?php echo e($site_info->copyright); ?>">
                                        <small class="form-text text-muted"><?php echo e(__('content.recommended_tags')); ?>

                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('a', 'copyright')"><?php echo e(__('<a href="">')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('br', 'copyright')"><?php echo e(__('<br>')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('b', 'copyright')"><?php echo e(__('<b>')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('i', 'copyright')"><?php echo e(__('<i>')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('span', 'copyright')"><?php echo e(__('<span>')); ?></span>
                                            <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('p', 'copyright')"><?php echo e(__('<p>')); ?></span>
                                        </small>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary mr-2"><?php echo e(__('content.submit')); ?></button>
                                    <a href="#" class="btn btn-primary" data-toggle="modal" data-target="#siteInfoDestroyModal<?php echo e($site_info->id); ?>">
                                        <i class="fa fa-trash"></i> <?php echo e(__('content.reset')); ?>

                                    </a>
                                </div>
                            </div>
                        </form>

                        <!-- Modal -->
                        <div class="modal fade" id="siteInfoDestroyModal<?php echo e($site_info->id); ?>" tabindex="-1" role="dialog" aria-labelledby="siteInfoDestroyModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="siteInfoDestroyModalCenterTitle"><?php echo e(__('content.delete')); ?></h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('content.close')); ?>">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body text-center">
                                        <?php echo e(__('content.you_wont_be_able_to_revert_this')); ?>

                                    </div>
                                    <div class="modal-footer">
                                        <?php if($demo_mode == "on"): ?>
                                            <!-- Include Alert Blade -->
                                            <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php else: ?>
                                            <form class="d-inline-block" action="<?php echo e(route('site-info.destroy', $site_info->id)); ?>" method="POST">
                                                <?php echo method_field('DELETE'); ?>
                                                <?php echo csrf_field(); ?>
                                                <?php endif; ?>

                                            <button type="button" class="btn btn-danger mr-1" data-dismiss="modal"><?php echo e(__('content.cancel')); ?></button>
                                            <button type="submit" class="btn btn-success"><?php echo e(__('content.yes_delete_it')); ?></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php else: ?>
                            <?php if($demo_mode == "on"): ?>
                            <!-- Include Alert Blade -->
                                <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <form action="<?php echo e(route('site-info.store')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php endif; ?>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="description"><?php echo e(__('content.description')); ?></label>
                                                <input type="text" name="description" class="form-control" id="description">
                                                <small class="form-text text-muted"><?php echo e(__('content.recommended_tags')); ?>

                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('a', 'description')"><?php echo e(__('<a href="">')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('br', 'description')"><?php echo e(__('<br>')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('b', 'description')"><?php echo e(__('<b>')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('i', 'description')"><?php echo e(__('<i>')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('span', 'description')"><?php echo e(__('<span>')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('p', 'description')"><?php echo e(__('<p>')); ?></span>
                                                </small>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="copyright"><?php echo e(__('content.copyright')); ?></label>
                                                <input type="text" name="copyright" class="form-control" id="copyright">
                                                <small class="form-text text-muted"><?php echo e(__('content.recommended_tags')); ?>

                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('a', 'copyright')"><?php echo e(__('<a href="">')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('br', 'copyright')"><?php echo e(__('<br>')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('b', 'copyright')"><?php echo e(__('<b>')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('i', 'copyright')"><?php echo e(__('<i>')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('span', 'copyright')"><?php echo e(__('<span>')); ?></span>
                                                    <span class="text-danger font-weight-bold custom-tag mr-1" onclick="insertTag('p', 'copyright')"><?php echo e(__('<p>')); ?></span>
                                                </small>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-primary mr-2"><?php echo e(__('content.submit')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/beevgisw/grievances/resources/views/admin/setting/site_info/create.blade.php ENDPATH**/ ?>