<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">

    <title>Page is not found</title>

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Title -->
    <title><?php if(!empty($page_builder->meta_title)): ?> <?php echo e($page_builder->meta_title); ?> <?php elseif(isset($seo)): ?> <?php echo e($seo->meta_title); ?> <?php endif; ?></title>

    <?php if(!empty($favicon->favicon_image)): ?>
        <!-- Favicon -->
        <link href="<?php echo e(asset('uploads/img/general/'.$favicon->favicon_image)); ?>" sizes="128x128" rel="shortcut icon" type="image/x-icon" />
        <link href="<?php echo e(asset('uploads/img/general/'.$favicon->favicon_image)); ?>" sizes="128x128" rel="shortcut icon" />
    <?php else: ?>
        <!-- Favicon -->
        <link href="<?php echo e(asset('uploads/img/dummy/favicon.png')); ?>" sizes="128x128" rel="shortcut icon" type="image/x-icon" />
        <link href="<?php echo e(asset('uploads/img/dummy/favicon.png')); ?>" sizes="128x128" rel="shortcut icon" />
    <?php endif; ?>

    <!-- ===========  All Stylesheet ================= -->
    <!--  Icon css plugins -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/icons.css')); ?>">

    <!--  Bootstrap css plugins -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/bootstrap.min.css')); ?>">
    <style>

        :root {
            <?php if(isset($color_option)): ?>

            <?php if($color_option->color_option != 0): ?>
            --main-color: <?php echo e($color_option->main_color); ?>;
            --secondary-color: <?php echo e($color_option->secondary_color); ?>;
            --tertiary-color: <?php echo e($color_option->tertiary_color); ?>;
            --scroll-button-color: <?php echo e($color_option->scroll_button_color); ?>;
            --bottom-button-color: <?php echo e($color_option->bottom_button_color); ?>;
            --bottom-button-hover-color: <?php echo e($color_option->bottom_button_hover_color); ?>;
            --side-button-color: <?php echo e($color_option->side_button_color); ?>;
            <?php else: ?>
            --main-color: #1A1AFF;
            --secondary-color: #F54748;
            --tertiary-color: #ffd44b;
            --scroll-button-color: #00baa3;
            --bottom-button-color: #212529;
            --bottom-button-hover-color: #333;
            --side-button-color: #25d366;
            <?php endif; ?>

            <?php else: ?>
            --main-color: #1A1AFF;
            --secondary-color: #F54748;
            --tertiary-color: #ffd44b;
            --scroll-button-color: #00baa3;
            --bottom-button-color: #212529;
            --bottom-button-hover-color: #333;
            --side-button-color: #25d366;
        <?php endif; ?>
}

    </style>
    <!--  main style css file -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/style.css')); ?>">
    <!--  helper style css file -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/helper-style.css')); ?>">

</head>
<body class="body-wrapper">

<section class="error-404-wrapper section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-3 text-center">
                <div class="error-content">
                    <img src="<?php echo e(asset('uploads/img/dummy/404.png')); ?>" alt="404 image">
                    <h1 class="mt-5 mb-3">Oops! Page not found.</h1>
                    <p>Sorry, an error has occured, Requested page not found!</p>
                    <a href="<?php echo e(url('/')); ?>" class="theme-btn mt-50">Back To Homepage</a>
                </div>
                <div class="leaf"><img src="<?php echo e(asset('uploads/img/dummy/leaf.png')); ?>" alt="leaf image"></div>
                <div class="leaf-copy"><img src="<?php echo e(asset('uploads/img/dummy/leaf.png')); ?>" alt="leaf image"></div>
            </div>
        </div>
    </div>
</section>


</body>
</html>

<?php /**PATH /home/beevgisw/grievances/resources/views/errors/404.blade.php ENDPATH**/ ?>