<?php $__env->startSection('content'); ?>


    <!-- Include Alert Blade -->
    <?php echo $__env->make('admin.alert.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Form row -->
    <div class="row">
        <div class="col-xl-12 box-margin height-card">
            <div class="card card-body">
                <h4 class="card-title"><?php echo e(__('content.profile')); ?></h4>
            <?php if($demo_mode == "on"): ?>
                <!-- Include Alert Blade -->
                    <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php else: ?>
                    <form  action="<?php echo e(route('profile.update', $user->id)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo method_field('PUT'); ?>
                        <?php echo csrf_field(); ?>
                        <?php endif; ?>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name"><?php echo e(__('content.name')); ?> <span class="text-red">*</span></label>
                                <input id="name" name="name" type="text" class="form-control" value="<?php echo e($user->name); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="email"><?php echo e(__('content.email')); ?> <span class="text-red">*</span></label>
                                <input id="email" name="email" type="email" class="form-control" value="<?php echo e($user->email); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label for="image"><?php echo e(__('content.image')); ?> (<?php echo e(__('content.size')); ?> 128x128)(.png, .jpg, .jpeg)</label>
                                <input id="image" name="profile_photo_path" type="file" class="form-control-file">
                                <?php if(!empty($user->profile_photo_path)): ?>
                                    <img src="<?php echo e(asset('uploads/img/profile/admin/'.$user->profile_photo_path)); ?>" class="img-fluid image-size rounded-circle mt-3" alt="profile image">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('uploads/img/dummy/128x128.jpg')); ?>" class="img-fluid image-size rounded-circle mt-3" alt="profile image">
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary">
                                <?php echo e(__('content.submit')); ?>

                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/beevgisw/grievances/resources/views/admin/profile/edit.blade.php ENDPATH**/ ?>