<?php $__env->startSection('content'); ?>

    <!-- Form row -->
    <div class="row">

        <div class="col-xl-12 box-margin height-card">
            <div class="card card-body">
                <h4 class="card-title"><?php echo e(__('content.header_image')); ?>

                        <div class="btn-group">
                            <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <?php echo e(__('content.'.$style)); ?>

                            </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="<?php echo e(route('header-image.create', ['style' => 'style1'])); ?>"><?php echo e(__('content.style1')); ?></a>
                                <a class="dropdown-item" href="<?php echo e(route('header-image.create', ['style' => 'style2'])); ?>"><?php echo e(__('content.style2')); ?></a>
                                <a class="dropdown-item" href="<?php echo e(route('header-image.create', ['style' => 'style3'])); ?>"><?php echo e(__('content.style3')); ?></a>
                            </div>
                        </div>
                </h4>
            <?php if(isset($header_image)): ?>
                <?php if($demo_mode == "on"): ?>
                    <!-- Include Alert Blade -->
                        <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <form action="<?php echo e(route('header-image.update', $header_image->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo method_field('PUT'); ?>
                            <?php echo csrf_field(); ?>
                            <?php endif; ?>

                            <input name="style" type="hidden" value="<?php echo e($style); ?>">

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="section_image"><?php echo e(__('content.image')); ?> (<?php echo e(__('content.size')); ?> 120 x 25) (.svg, .jpg, .jpeg, .png, .webp, .gif)</label>
                                        <input type="file" name="section_image" class="form-control-file" id="section_image">
                                        <small class="form-text text-muted"><?php echo e(__('content.please_use_recommended_sizes')); ?></small>
                                    </div>
                                    <div class="height-card box-margin">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="avatar-area text-center">
                                                    <div class="media">
                                                        <?php if(!empty($header_image->section_image)): ?>
                                                            <a  class="d-block mx-auto" href="#" data-toggle="tooltip" data-placement="top" data-original-title="<?php echo e(__('content.current_image')); ?>">
                                                                <img src="<?php echo e(asset('uploads/img/general/'.$header_image->section_image)); ?>" alt="logo image" class="rounded">
                                                            </a>
                                                        <?php else: ?>
                                                            <a class="d-block mx-auto" href="#" data-toggle="tooltip" data-placement="top" data-original-title="<?php echo e(__('content.not_yet_created')); ?>">
                                                                <img src="<?php echo e(asset('uploads/img/dummy/no-image.jpg')); ?>" alt="no image" class="rounded w-25">
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php if(!empty($header_image->section_image)): ?>
                                                        <a class="mt-3 d-block" href="#" data-toggle="modal" data-target="#deleteImageModal<?php echo e($header_image->id); ?>">
                                                            <i class="fa fa-trash text-danger font-18"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                                <!--end card-body-->
                                            </div>
                                        </div>
                                        <!--end card-->
                                    </div>
                                    <!--end col-->
                                </div>
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary mr-2"><?php echo e(__('content.submit')); ?></button>
                                    <a href="#" class="btn btn-primary" data-toggle="modal" data-target="#headerImageDestroyModal<?php echo e($header_image->id); ?>">
                                        <i class="fa fa-trash"></i> <?php echo e(__('content.reset')); ?>

                                    </a>
                                </div>
                            </div>
                        </form>

                        <!-- Modal -->
                        <div class="modal fade" id="deleteImageModal<?php echo e($header_image->id); ?>" tabindex="-1" role="dialog" aria-labelledby="messageModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="messageModalCenterTitle"><?php echo e(__('content.delete')); ?></h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('content.close')); ?>">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body text-center">
                                        <?php echo e(__('content.you_wont_be_able_to_revert_this')); ?>

                                    </div>
                                    <div class="modal-footer">
                                        <?php if($demo_mode == "on"): ?>
                                            <!-- Include Alert Blade -->
                                            <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php else: ?>
                                            <form class="d-inline-block" action="<?php echo e(route('header-image.destroy_image', $header_image->id)); ?>" method="POST">
                                                <?php echo method_field('DELETE'); ?>
                                                <?php echo csrf_field(); ?>
                                                <?php endif; ?>

                                            <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('content.cancel')); ?></button>
                                            <button type="submit" class="btn btn-success"><?php echo e(__('content.yes_delete_it')); ?></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Modal -->
                        <div class="modal fade" id="headerImageDestroyModal<?php echo e($header_image->id); ?>" tabindex="-1" role="dialog" aria-labelledby="headerImageDestroyModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-sm" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="headerImageDestroyModalCenterTitle"><?php echo e(__('content.delete')); ?></h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('content.close')); ?>">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body text-center">
                                        <?php echo e(__('content.you_wont_be_able_to_revert_this')); ?>

                                    </div>
                                    <div class="modal-footer">
                                        <?php if($demo_mode == "on"): ?>
                                            <!-- Include Alert Blade -->
                                            <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php else: ?>
                                            <form class="d-inline-block" action="<?php echo e(route('header-image.destroy', $header_image->id)); ?>" method="POST">
                                                <?php echo method_field('DELETE'); ?>
                                                <?php echo csrf_field(); ?>
                                                <?php endif; ?>

                                            <button type="button" class="btn btn-danger mr-1" data-dismiss="modal"><?php echo e(__('content.cancel')); ?></button>
                                            <button type="submit" class="btn btn-success"><?php echo e(__('content.yes_delete_it')); ?></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php else: ?>
                            <?php if($demo_mode == "on"): ?>
                            <!-- Include Alert Blade -->
                                <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <form action="<?php echo e(route('header-image.store')); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php endif; ?>

                                    <input name="style" type="hidden" value="<?php echo e($style); ?>">

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="section_image"><?php echo e(__('content.image')); ?> (<?php echo e(__('content.size')); ?> 120 x 25) (.svg, .jpg, .jpeg, .png, .webp, .gif)</label>
                                                <input type="file" name="section_image" class="form-control-file" id="section_image">
                                                <small class="form-text text-muted"><?php echo e(__('content.please_use_recommended_sizes')); ?></small>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-primary mr-2"><?php echo e(__('content.submit')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/beevgisw/grievances/resources/views/admin/setting/header_image/create.blade.php ENDPATH**/ ?>