<?php $__env->startSection('content'); ?>

    <!-- Form row -->
    <div class="row">
        <div class="col-xl-12 box-margin height-card">
            <div class="card">
                <div class="card-body">
                    <div class="d-md-flex justify-content-between align-items-center mb-20">
                        <h6 class="card-title mb-0"><?php echo e(__('content.add_photo')); ?></h6>
                    </div>
                <?php if($demo_mode == "on"): ?>
                    <!-- Include Alert Blade -->
                        <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <form action="<?php echo e(route('photo.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php endif; ?>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="gallery_image"><?php echo e(__('content.image')); ?> (.svg, .jpg, .jpeg, .png, .webp, gif) <span class="text-red">*</span></label>
                                    <input type="file" name="gallery_image" class="form-control-file" id="gallery_image" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="order"><?php echo e(__('content.order')); ?></label>
                                    <input type="number" name="order" class="form-control" id="order" value="0" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary mr-2"><?php echo e(__('content.submit')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- end row -->

    <!-- Sliders row -->
   <?php if(count($galleries) > 0): ?>
       <div class="row">
           <div class="col-12 box-margin">
               <div class="card">
                   <div class="card-body">
                       <h5 class="card-title"><?php echo e(__('content.photos')); ?></h5>
                       <div class="row text-center">
                          <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                               <div class="col-sm-6 col-xl-3 mb-4">
                                   <a href="<?php echo e(asset('uploads/img/photo/'.$gallery->gallery_image)); ?>" data-lightbox="example-set">
                                       <img src="<?php echo e(asset('uploads/img/photo/'.$gallery->gallery_image)); ?>" class="img-fluid mb-30" alt="gallery image">
                                   </a>
                                  <div>
                                      <div>
                                          <div class="form-group">
                                              <input  type="text" value="<?php echo e(url('/'.'uploads/img/photo/'.$gallery->gallery_image)); ?>" id="copyImageLink<?php echo e($gallery->id); ?>">
                                              <button class="btn btn-success mt-3" onclick="copyImageLink(<?php echo e($gallery->id); ?>)"><?php echo e(__('Copy Image Link')); ?></button>
                                          </div>
                                      </div>
                                      <a href="<?php echo e(route('photo.edit', $gallery->id)); ?>" class="mr-2">
                                          <i class="fa fa-edit text-info font-18"></i>
                                      </a>
                                      <a href="#" data-toggle="modal" data-target="#deleteModel<?php echo e($gallery->id); ?>">
                                          <i class="fa fa-trash text-danger font-18"></i>
                                      </a>
                                          <!-- Modal -->
                                          <div class="modal fade" id="deleteModel<?php echo e($gallery->id); ?>" tabindex="-1" role="dialog">
                                              <div class="modal-dialog modal-dialog-centered modal-sm" role="document">
                                                  <div class="modal-content">
                                                      <div class="modal-header">
                                                          <h5 class="modal-title" id="exampleModalCenterTitle"><?php echo e(__('content.delete')); ?></h5>
                                                          <button type="button" class="close" data-dismiss="modal" aria-label="<?php echo e(__('content.close')); ?>">
                                                              <span aria-hidden="true">&times;</span>
                                                          </button>
                                                      </div>
                                                      <div class="modal-body text-center">
                                                          <?php echo e(__('content.you_wont_be_able_to_revert_this')); ?>

                                                      </div>
                                                      <div class="modal-footer">
                                                      <?php if($demo_mode == "on"): ?>
                                                          <!-- Include Alert Blade -->
                                                              <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                          <?php else: ?>
                                                              <form class="d-inline-block" action="<?php echo e(route('photo.destroy', $gallery->id)); ?>" method="POST">
                                                                  <?php echo csrf_field(); ?>
                                                                  <?php echo method_field('DELETE'); ?>
                                                                  <?php endif; ?>

                                                          <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('content.cancel')); ?></button>
                                                          <button type="submit" class="btn btn-success"><?php echo e(__('content.yes_delete_it')); ?></button>
                                                          </form>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                  </div>
                               </div>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                       </div>
                   </div>
               </div>
           </div>
       </div>
       <div class="row">
           <div class="col-md-12">
               <?php echo e($galleries->links()); ?>

           </div>
       </div>
       <?php endif; ?>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/beevgisw/grievances/resources/views/admin/photo/create.blade.php ENDPATH**/ ?>