<?php $__env->startSection('content'); ?>

    <!-- Form row -->
    <div class="row">
        <div class="col-xl-12 box-margin height-card">
            <div class="card card-body">
                <div class="d-md-flex justify-content-between align-items-center mb-20">
                    <h4 class="card-title"><?php echo e(__('content.edit_menu_name')); ?></h4>
                    <div>
                        <a href="<?php echo e(url()->previous()); ?>"  class="btn btn-primary"><i class="fas fa-angle-left"></i> <?php echo e(__('content.back')); ?></a>
                    </div>
                </div>
            <?php if($demo_mode == "on"): ?>
                <!-- Include Alert Blade -->
                    <?php echo $__env->make('admin.demo_mode.demo-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php else: ?>
                    <form action="<?php echo e(route('menu.update', $menu->id)); ?>" method="POST">
                        <?php echo method_field('PUT'); ?>
                        <?php echo csrf_field(); ?>
                        <?php endif; ?>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="menu_name"><?php echo e(__('content.menu_name')); ?> <span class="text-red">*</span></label>
                                    <input type="text" name="menu_name" class="form-control" id="menu_name" value="<?php echo e($menu->menu_name); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="uri" class="col-form-label"><?php echo e(__('content.pages_within_the_site')); ?> </label>
                                    <select class="form-control" name="uri" id="uri">
                                        <option value=""><?php echo e(__('content.empty')); ?></option>
                                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($page->page_name != 'blog-search-index'): ?>
                                            <option value="<?php echo e($page->page_uri); ?>" <?php echo e($page->page_uri == $menu->uri ? 'selected' : ''); ?>><?php echo e($page->page_uri); ?></option>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <small class="form-text text-muted"><?php echo e(__('content.to_use_the_url_enter_empty_in_this_field')); ?></small>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="url"><?php echo e(__('content.url')); ?></label>
                                    <input type="text" name="url" class="form-control" id="url" value="<?php echo e($menu->url); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="order"><?php echo e(__('content.order')); ?></label>
                                    <input type="number" name="order" class="form-control" id="order" value="<?php echo e($menu->order); ?>" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="status" class="col-form-label"><?php echo e(__('content.status')); ?></label>
                                    <select class="form-control" name="status" id="status">
                                        <option value="published" selected><?php echo e(__('content.select_your_option')); ?></option>
                                        <option value="published" <?php echo e($menu->status == "published" ? 'selected' : ''); ?>><?php echo e(__('content.published')); ?></option>
                                        <option value="draft" <?php echo e($menu->status == "draft" ? 'selected' : ''); ?>><?php echo e(__('content.draft')); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <small class="form-text text-muted"><?php echo e(__('content.required_fields')); ?></small>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary mr-2"><?php echo e(__('content.submit')); ?></button>
                            </div>
                        </div>
                    </form>
            </div>
        </div>
    </div>
    <!-- end row -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/beevgisw/grievances/resources/views/admin/menu/menu/edit.blade.php ENDPATH**/ ?>