<?php

namespace Database\Seeders;

use App\Models\Admin\PageBuilder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PageBuilderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create data
        PageBuilder::insert([
            [
                'page_uri' => '/',
                'page_name' => 'public-homepage-index',
                'page_name_id' => 1,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"banner-style1","folder":"banner","order":0},{"id":"feature-style1","folder":"feature","order":0},{"id":"about-style1","folder":"about","order":0},{"id":"buy-now-style1","folder":"buy_now","order":0},{"id":"work-process-style1","folder":"work_process","order":0},{"id":"testimonial-style1","folder":"testimonial","order":0},{"id":"faq-style1","folder":"faq","order":0},{"id":"blog-style1","folder":"blog","order":0},{"id":"call-to-action-style1","folder":"call_to_action","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => null,
                'breadcrumb_item' => null,
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Homepage',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'index-2',
                'page_name' => 'homepage-2-index',
                'page_name_id' => 2,
                'default_item' => '[{"id":"header-style2","folder":"header","order":0},{"id":"banner-style2","folder":"banner","order":0},{"id":"feature-style2","folder":"feature","order":0},{"id":"about-style2","folder":"about","order":0},{"id":"about-style3","folder":"about","order":0},{"id":"service-style2","folder":"service","order":0},{"id":"about-style4","folder":"about","order":0},{"id":"plan-style1","folder":"plan","order":0},{"id":"testimonial-style2","folder":"testimonial","order":0},{"id":"call-to-action-style2","folder":"call_to_action","order":0},{"id":"footer-style2","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => null,
                'breadcrumb_item' => null,
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Homepage',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'index-3',
                'page_name' => 'homepage-3-index',
                'page_name_id' => 3,
                'default_item' => '[{"id":"header-style3","folder":"header","order":0},{"id":"banner-style3","folder":"banner","order":0},{"id":"feature-style3","folder":"feature","order":0},{"id":"about-style5","folder":"about","order":0},{"id":"about-style6","folder":"about","order":0},{"id":"work-process-style2","folder":"work_process","order":0},{"id":"plan-style1","folder":"plan","order":0},{"id":"testimonial-style3","folder":"testimonial","order":0},{"id":"faq-style2","folder":"faq","order":0},{"id":"call-to-action-style3","folder":"call_to_action","order":0},{"id":"footer-style2","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => null,
                'breadcrumb_item' => null,
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Homepage',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'about',
                'page_name' => 'about-index',
                'page_name_id' => 4,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"about-style7","folder":"about","order":0},{"id":"about-style8","folder":"about","order":0},{"id":"testimonial-style1","folder":"testimonial","order":0},{"id":"team-style1","folder":"team","order":0},{"id":"subscribe-style1","folder":"subscribe","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'About Us',
                'breadcrumb_item' => '<a href="#">Home</a>, About Us',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'About Us',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'services',
                'page_name' => 'service-index',
                'page_name_id' => 5,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"service-style3","folder":"service","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'Our Services',
                'breadcrumb_item' => '<a href="#">Home</a>, Our Services',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Our Services',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'service',
                'page_name' => 'service-detail-show',
                'page_name_id' => 6,
                'default_item' => null,
                'updated_item' => null,
                'meta_title' => null,
                'breadcrumb_title' => 'Service Detail',
                'breadcrumb_item' => '<a href="#">Home</a>, Service Detail',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'service/category',
                'page_name' => 'service-category-index',
                'page_name_id' => 7,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Service Category',
                'breadcrumb_item' => '<a href="#">Home</a>, Service Category',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => null,
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 2,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'faqs',
                'page_name' => 'faq-index',
                'page_name_id' => 8,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"faq-style3","folder":"faq","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'Faqs',
                'breadcrumb_item' => '<a href="#">Home</a>, Our Faqs',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Fags',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'gallery',
                'page_name' => 'gallery-index',
                'page_name_id' => 9,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"gallery-style2","folder":"gallery","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'Gallery',
                'breadcrumb_item' => '<a href="#">Home</a>, Our Gallery',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Gallery',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'teams',
                'page_name' => 'team-index',
                'page_name_id' => 10,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"team-style2","folder":"team","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'Teams',
                'breadcrumb_item' => '<a href="#">Home</a>, Our Teams',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Teams',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'team/category',
                'page_name' => 'team-category-index',
                'page_name_id' => 11,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Team Category',
                'breadcrumb_item' => '<a href="#">Home</a>, Team Category',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => null,
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 2,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'portfolios',
                'page_name' => 'portfolio-index',
                'page_name_id' => 12,
                'default_item' => '[{"id":"header-style1","folder":"header","order":1},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"portfolio-style2","folder":"portfolio","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'Portfolio',
                'breadcrumb_item' => '<a href="#">Home</a>, Our Portfolio',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Portfolio',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'portfolio',
                'page_name' => 'portfolio-detail-show',
                'page_name_id' => 13,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Portfolio Detail',
                'breadcrumb_item' => '<a href="#">Home</a>, Portfolio Detail',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => null,
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'portfolio/category',
                'page_name' => 'portfolio-category-index',
                'page_name_id' => 14,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Portfolio Category',
                'breadcrumb_item' => '<a href="#">Home</a>, Portfolio Category',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => null,
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 2,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'plans',
                'page_name' => 'plan-index',
                'page_name_id' => 15,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"plan-style1","folder":"plan","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'Pricing',
                'breadcrumb_item' => '<a href="#">Home</a>, Plans',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Pricing',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'careers',
                'page_name' => 'career-index',
                'page_name_id' => 16,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"career-style2","folder":"career","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'Our Careers',
                'breadcrumb_item' => '<a href="#">Home</a>, Our Careers',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Career',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'career',
                'page_name' => 'career-detail-show',
                'page_name_id' => 17,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Career Detail',
                'breadcrumb_item' => '<a href="#">Home</a>, Career Detail',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => null,
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'blogs',
                'page_name' => 'blog-index',
                'page_name_id' => 18,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"blog-style2","folder":"blog","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'Our Blogs',
                'breadcrumb_item' => '<a href="#">Home</a>, Blogs',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Our Blogs',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'blog',
                'page_name' => 'blog-detail-show',
                'page_name_id' => 19,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Blog Detail',
                'breadcrumb_item' => '<a href="#">Home</a>, Blog Detail',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Blog Detail',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'blog/category',
                'page_name' => 'blog-category-index',
                'page_name_id' => 20,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Blog Category',
                'breadcrumb_item' => '<a href="#">Home</a>, Blog Category',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => null,
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 2,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'blog/tag',
                'page_name' => 'blog-tag-index',
                'page_name_id' => 21,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Blog Tag',
                'breadcrumb_item' => '<a href="#">Home</a>, Blog Tag',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => null,
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 2,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'blog/search',
                'page_name' => 'blog-search-index',
                'page_name_id' => 22,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Search Results',
                'breadcrumb_item' => '<a href="#">Home</a>, Search Results',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => null,
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 2,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'contact',
                'page_name' => 'contact-index',
                'page_name_id' => 23,
                'default_item' => '[{"id":"header-style1","folder":"header","order":0},{"id":"breadcrumb-style1","folder":"breadcrumb","order":0},{"id":"contact-style1","folder":"contact","order":0},{"id":"map-style1","folder":"map","order":0},{"id":"footer-style1","folder":"footer","order":0}]',
                'updated_item' => null,
                'breadcrumb_title' => 'Contact Us',
                'breadcrumb_item' => '<a href="#">Home</a>, Contact Us',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Contact Us',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ],
            [
                'page_uri' => 'page',
                'page_name' => 'page-detail-show',
                'page_name_id' => 24,
                'default_item' => null,
                'updated_item' => null,
                'breadcrumb_title' => 'Page Detail',
                'breadcrumb_item' => '<a href="#">Home</a>, Page Detail',
                'breadcrumb_status' => 'no',
                'custom_breadcrumb_image' => null,
                'meta_title' => 'Page Detail',
                'meta_description' => null,
                'meta_keyword' => null,
                'order' => 0,
                'segment_count' => 1,
                'is_default' => 'yes',
                'status' => 1,
            ]
        ]);

    }
}
